/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.ExecutableUtil;
import com.aptana.core.util.PathUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ProcessUtil;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShellExecutable {
    private static final String APTANA_VERSION = "APTANA_VERSION";
    private static final String BASH_ENV = "BASH_ENV";
    private static final String[] POSSIBLE_SHELL_LOCATIONS_WIN32 = new String[]{"%PROGRAMW6432%\\Git\\bin", "%PROGRAMFILES%\\Git\\bin", "%PROGRAMFILES(X86)%\\Git\\bin", "C:\\RailsInstaller\\Git\\bin"};
    private static final String[] ENV_FILTER = new String[]{"_", "BASH_ENV", "TMP", "APP_ICON*", "JAVA_MAIN_CLASS*", "JAVA_STARTED_ON_FIRST_THREAD*"};
    public static final String PATH_SEPARATOR = ":";
    private static final String PATH = "PATH";
    private static final String SH_EXE = "sh.exe";
    private static final String BASH = "bash";
    private static final String RCFILE = "$os$/.aptanarc";
    private static boolean initializing = false;
    private static IPath shellPath = null;
    private static IPath shellRCPath = null;
    private static Map<String, String> shellEnvironment;
    private static Map<IPath, Map<String, String>> workingDirToEnvCache;
    private static List<String> newPathLocations;

    static {
        workingDirToEnvCache = new HashMap<IPath, Map<String, String>>();
        newPathLocations = new ArrayList<String>(5);
    }

    private ShellExecutable() {
    }

    public static synchronized IPath getPath() throws CoreException {
        if (shellPath == null) {
            if (initializing) {
                return null;
            }
            boolean isWin32 = "win32".equals(Platform.getOS());
            try {
                initializing = true;
                shellPath = ShellExecutable.getPreferenceShellPath();
                if (shellPath == null) {
                    shellPath = ExecutableUtil.find(isWin32 ? SH_EXE : BASH, false, ShellExecutable.getPossibleShellLocations());
                }
            }
            finally {
                initializing = false;
            }
            if (shellPath == null) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.core", "Shell executable could not be found."));
            }
        }
        return shellPath;
    }

    private static List<IPath> getPossibleShellLocations() {
        if ("win32".equals(Platform.getOS())) {
            ArrayList<IPath> list = new ArrayList<IPath>();
            String[] stringArray = POSSIBLE_SHELL_LOCATIONS_WIN32;
            int n = POSSIBLE_SHELL_LOCATIONS_WIN32.length;
            int n2 = 0;
            while (n2 < n) {
                String location = stringArray[n2];
                IPath path = Path.fromOSString((String)PlatformUtil.expandEnvironmentStrings(location));
                if (path.toFile().isDirectory()) {
                    list.add(path);
                }
                ++n2;
            }
            return list;
        }
        return null;
    }

    public static synchronized IPath getShellRCPath() {
        File file;
        URL url;
        if (shellRCPath == null && (url = FileLocator.find((Bundle)CorePlugin.getDefault().getBundle(), (IPath)Path.fromPortableString((String)RCFILE), null)) != null && (file = ResourceUtil.resourcePathToFile(url)) != null && file.exists()) {
            shellRCPath = Path.fromOSString((String)file.getAbsolutePath());
        }
        return shellRCPath;
    }

    private static IPath getPreferenceShellPath() {
        String pref = InstanceScope.INSTANCE.getNode("com.aptana.core").get("shell_executable_path", null);
        if (pref != null && !StringUtil.isEmpty(pref)) {
            IPath path = Path.fromOSString((String)pref);
            if (path.toFile().isDirectory()) {
                boolean isWin32 = "win32".equals(Platform.getOS());
                path = path.append(isWin32 ? SH_EXE : BASH);
            }
            if (ExecutableUtil.isExecutable(path)) {
                return path;
            }
            IdeLog.logWarning((Plugin)CorePlugin.getDefault(), "Shell executable path preference point to an invalid location");
        }
        return null;
    }

    public static void setPreferenceShellPath(IPath path) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.core");
        if (path != null) {
            prefs.put("shell_executable_path", path.toOSString());
        } else {
            prefs.remove("shell_executable_path");
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logWarning((Plugin)CorePlugin.getDefault(), "Saving preferences failed.", e);
        }
        shellPath = null;
        shellEnvironment = null;
    }

    public static synchronized Map<String, String> getEnvironment() {
        if (shellEnvironment == null) {
            shellEnvironment = ShellExecutable.getEnvironment(null);
        }
        return shellEnvironment;
    }

    public static synchronized void updatePathEnvironment(String ... newPaths) {
        newPathLocations.addAll(Arrays.asList(newPaths));
        for (IPath locationKey : workingDirToEnvCache.keySet()) {
            ShellExecutable.updatePathForLocationKey(locationKey);
        }
    }

    public static List<String> getNewPathLocations() {
        return newPathLocations;
    }

    private static void updatePathForLocationKey(IPath locationKey) {
        Map<String, String> workingDirEnvironment = workingDirToEnvCache.get(locationKey);
        if (PlatformUtil.isWindows() && !CollectionsUtil.isEmpty(newPathLocations) && workingDirEnvironment != null) {
            String resultPath = workingDirEnvironment.get(PATH);
            if (StringUtil.isEmpty(resultPath)) {
                resultPath = workingDirEnvironment.get("Path");
            }
            resultPath = PathUtil.convertPATH(resultPath);
            for (String newPath : newPathLocations) {
                resultPath = StringUtil.join(File.pathSeparator, resultPath, PlatformUtil.expandEnvironmentStrings(newPath));
            }
            List<String> pathLocations = StringUtil.split(resultPath, File.pathSeparatorChar);
            CollectionsUtil.removeDuplicates(pathLocations);
            resultPath = StringUtil.join(File.pathSeparator, pathLocations);
            workingDirEnvironment.put(PATH, resultPath);
            workingDirEnvironment.put("Path", resultPath);
        }
    }

    public static synchronized Map<String, String> getEnvironment(IPath workingDirectory) {
        if (workingDirectory == null && shellEnvironment != null) {
            return shellEnvironment;
        }
        if (!workingDirToEnvCache.containsKey(workingDirectory)) {
            IPath shellPath = null;
            try {
                shellPath = ShellExecutable.getPath();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            Map<String, String> result = null;
            if (shellPath != null) {
                String envCommand = "env";
                if (!PlatformUtil.isWindows()) {
                    try {
                        IStatus status = ProcessUtil.processResult(ShellExecutable.run(envCommand, workingDirectory, null, new String[0]));
                        if (status.isOK()) {
                            result = ShellExecutable.buildEnvironment(status.getMessage());
                        } else {
                            IdeLog.logError((Plugin)CorePlugin.getDefault(), "Get shell environment failed: " + status.getMessage());
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)CorePlugin.getDefault(), "Get shell environment failed.", e);
                    }
                }
            }
            if (result == null) {
                result = new HashMap<String, String>(System.getenv());
            }
            workingDirToEnvCache.put(workingDirectory, result);
            ShellExecutable.updatePathForLocationKey(workingDirectory);
        }
        return workingDirToEnvCache.get(workingDirectory);
    }

    private static Map<String, String> buildEnvironment(String envp) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("HOME", PlatformUtil.expandEnvironmentStrings("~"));
        StringTokenizer tok = new StringTokenizer(envp, "\r\n");
        while (tok.hasMoreTokens()) {
            String envstring = tok.nextToken();
            int eqlsign = envstring.indexOf(61);
            if (eqlsign == -1) continue;
            env.put(envstring.substring(0, eqlsign), envstring.substring(eqlsign + 1));
        }
        String[] stringArray = ENV_FILTER;
        int n = ENV_FILTER.length;
        int n2 = 0;
        while (n2 < n) {
            String var = stringArray[n2];
            if (var.charAt(var.length() - 1) == '*') {
                String prefix = var.substring(0, var.length() - 1);
                Iterator i = env.entrySet().iterator();
                while (i.hasNext()) {
                    if (!((String)i.next().getKey()).startsWith(prefix)) continue;
                    i.remove();
                }
            } else {
                env.remove(var);
            }
            ++n2;
        }
        return env;
    }

    private static synchronized List<String> toShellCommand(List<String> command) throws CoreException {
        if (initializing) {
            return command;
        }
        ArrayList<String> shellCommand = new ArrayList<String>();
        shellCommand.add(ShellExecutable.getPath().toOSString());
        shellCommand.add("--login");
        shellCommand.add("--noprofile");
        shellCommand.add("-c");
        StringBuffer sb = new StringBuffer();
        for (String arg : command) {
            sb.append(arg.replaceAll("\"|'|\\(|\\)| ", "\\\\$0")).append(' ');
        }
        shellCommand.add(sb.toString().trim());
        return shellCommand;
    }

    private static synchronized Map<String, String> toShellEnvironment(Map<String, String> environment) {
        environment.put(APTANA_VERSION, EclipseUtil.getStudioVersion());
        if (initializing) {
            return environment;
        }
        IPath rcPath = ShellExecutable.getShellRCPath();
        if (rcPath != null) {
            environment.put(BASH_ENV, rcPath.toOSString());
        }
        return environment;
    }

    public static List<String> toShellCommand(String command, String ... arguments) throws CoreException {
        ArrayList<String> commands = new ArrayList<String>(Arrays.asList(arguments));
        commands.add(0, command);
        return ShellExecutable.toShellCommand(commands);
    }

    public static Process run(List<String> command, IPath workingDirectory, Map<String, String> environment) throws IOException, CoreException {
        ProcessBuilder processBuilder = new ProcessBuilder(ShellExecutable.toShellCommand(command));
        if (workingDirectory != null && workingDirectory.toFile().isDirectory()) {
            processBuilder.directory(workingDirectory.toFile());
        }
        if (environment != null && !environment.isEmpty()) {
            processBuilder.environment().putAll(environment);
        }
        processBuilder.environment().putAll(ShellExecutable.toShellEnvironment(processBuilder.environment()));
        return processBuilder.start();
    }

    public static Process run(String command, IPath workingDirectory, Map<String, String> environment, String ... arguments) throws IOException, CoreException {
        ArrayList<String> commands = new ArrayList<String>(Arrays.asList(arguments));
        commands.add(0, command);
        return ShellExecutable.run(commands, workingDirectory, environment);
    }

    public static Process run(IPath executablePath, IPath workingDirectory, Map<String, String> environment, String ... arguments) throws IOException, CoreException {
        return ShellExecutable.run(executablePath.toOSString(), workingDirectory, environment, arguments);
    }

    public static void wipeCache() {
        shellEnvironment = null;
        workingDirToEnvCache.clear();
    }
}

